using System;
using Server;
using Server.Gumps;
using Server.Items;
using Server.Mobiles;

namespace Server.Items
{
   [Flipable( 0x2B04, 0x2B05 )]
   public class Plast : BaseCloak
   {
		public override int ArtifactRarity{ get{ return 100; } }
      
      [Constructable]
      public Plast() : base( 0x2B05 )
      {
         Weight = 2.5;
         Name = "Plast";
			Hue = 1182;
   		LootType = LootType.Blessed;
   		Attributes.BonusDex = 5;
   		Attributes.BonusHits = 10;
   		Attributes.BonusInt = 10;
   		Attributes.BonusMana = 25;
   		Attributes.CastRecovery = 4;
   		Attributes.CastSpeed = 4;
   		Attributes.EnhancePotions = 10;
   		Attributes.LowerManaCost = 16;
   		Attributes.LowerRegCost = 10;
   		Attributes.Luck = 250;            
   		Attributes.RegenMana = 3;
   		Attributes.SpellDamage = 15; 
   		ClothingAttributes.MageArmor = 1;
   		Resistances.Physical = 5;
   		Resistances.Fire = 5;
   		Resistances.Cold = 5;
   		Resistances.Poison = 5;
   		Resistances.Energy = 5;
   		
			SkillBonuses.SetValues( 0, SkillName.MagicResist, 20.0 );
      }
      
		public override void OnDoubleClick( Mobile m )
		{
			if( Parent != m )
			{
				m.SendMessage( "Musis mit plast nasazen aby sel pouzit!" );
			}
			else if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes plast pouzit pokud s nekym obchodujes!" );
			}
			else
			{
			   if( m.HasGump( typeof(TravelWandGump) ) )
				  m.CloseGump( typeof(TravelWandGump) );
            
            m.SendGump( new TravelWandGump( m, (Item)this ) );
			}
		}

		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Travelling Cloak<basefont color=White>" );
		}

      public Plast( Serial serial ) : base( serial )
      {
      }

      public override void Serialize( GenericWriter writer )
      {
         base.Serialize( writer );
         writer.Write( (int) 0 );
      }
              
      public override void Deserialize(GenericReader reader)
      {
         base.Deserialize( reader );
         int version = reader.ReadInt();
      }
   }
}